	subroutine SOURCE0(iout, idbg, Ne, Nn, NnNd, ie, Soe, vA, rA, cA, lastA, Son)
! calculate the independent source [A]{So} (time-independent)
! NOTE: on the boundaries W = N by definition

	implicit none
	integer iout, idbg
	integer lastA
	integer Ne, Nn, NnNd			! array parameters
	integer ie(Ne,5)			! global connectivity array
	integer rA(Nn+1)			! global  arrays (compact rows)
	integer cA(NnNd)			! global  arrays (compact columns)
	real*8 vA(NnNd)				! global  arrays (compact values)
	real*8 Soe(Ne,4)			! element independent source nodal values
	real*8 Son(Nn)				! global  arrays

	integer e, m, ii, jj
	real*8 aa, src, Sn(Nn)

!	write(idbg,'(a)') ' --- SOURCE0 ---'	! ### TEMPORARY ###

! reset Son to 0
	Son = 0.		! use matrix form

! store the element So values in the nodal temporary Sn array
	do e = 1,Ne
	  do m = 1,4
	    Sn(ie(e, m)) = Soe(e,m)
	  enddo	! m
	enddo	! e

	do jj = 1, Nn
	  do ii = 1, Nn
	    aa = 0.
! access rank 2 sparse arrays
	    call ACCESS2(iout, idbg, Nn, NnNd, rA, cA, ii, jj, lastA, m)

	    if (m .ne. 0)	then
	      aa = vA(m)		! retrieve A
	    endif

	    src = aa*Sn(jj)

	    Son(ii) = Son(ii) - src	! -AijSj
	  enddo		! ii
	enddo		! jj

	return
	end
